% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colour-manip.R
\name{col_mix}
\alias{col_mix}
\title{Mix colours}
\usage{
col_mix(a, b, amount = 0.5, space = "rgb")
}
\arguments{
\item{a}{Either a character vector of colours or a colour palette function.}

\item{b}{A character vector of colours.}

\item{amount}{A numeric fraction between 0 and 1 giving the contribution of
the \code{b} colour.}

\item{space}{A string giving a colour space to perform mixing operation in.
Polar spaces are not recommended.}
}
\value{
A character vector of colours.
}
\description{
Produces an interpolation of two colours.
}
\examples{
col_mix("blue", "red") # purple
col_mix("blue", "red", amount = 1) # red
col_mix("blue", "red", amount = 0) # blue

# Not recommended:
col_mix("blue", "red", space = "hcl") # green!
}
\seealso{
Other colour manipulation: 
\code{\link{alpha}()},
\code{\link{col2hcl}()},
\code{\link{colour_manip}},
\code{\link{muted}()}
}
\concept{colour manipulation}
