"""
vmsetup functions for for dmm.
"""

import os
from command_runner import command_runner

def vmsetup(chroot, root_during_build, root_dev_in_vm):
    """
    Additional basic setup for a virtual machine.
    """
    os.system("sed -i 's/%s/%s/g' %s/boot/grub/grub.cfg" % (root_during_build,
                                                            root_dev_in_vm,
                                                            chroot))
    os.system("echo '/dev/%s / ext4 defaults 0 0' > %s/etc/fstab" % (root_dev_in_vm, chroot))

    # qemu's bios only reads the EFI files if it can find them in the right place, and
    # vfat doesn't support symlinks
    os.system("cp -r %s/boot/efi/EFI/debian %s/boot/efi/EFI/boot" % (chroot, chroot))
    os.system("cp -r %s/boot/efi/EFI/boot/grubx64.efi %s/boot/efi/EFI/boot/bootx64.efi" % (chroot, chroot))
    os.system(("sed -i 's/quiet/quiet console=ttyS0/g' %s/etc/default/grub") % chroot)
    os.system("chroot %s /usr/sbin/update-grub" % chroot)


