# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.identity import DefaultAzureCredential

from azure.mgmt.cloudhealth import CloudHealthMgmtClient

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-cloudhealth
# USAGE
    python signal_definitions_create_or_update.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = CloudHealthMgmtClient(
        credential=DefaultAzureCredential(),
        subscription_id="SUBSCRIPTION_ID",
    )

    response = client.signal_definitions.create_or_update(
        resource_group_name="rgopenapi",
        health_model_name="myHealthModel",
        signal_definition_name="sig1",
        resource={
            "properties": {
                "aggregationType": "None",
                "dataUnit": "byte",
                "dimension": "nodename",
                "dimensionFilter": "node1",
                "displayName": "cpu usage",
                "evaluationRules": {
                    "degradedRule": {"operator": "LowerThan", "threshold": "65"},
                    "unhealthyRule": {"operator": "LowerThan", "threshold": "60"},
                },
                "labels": {"key4788": "ixfvzsfnpvkkbrce"},
                "metricName": "cpuusage",
                "metricNamespace": "microsoft.compute/virtualMachines",
                "refreshInterval": "PT1M",
                "signalKind": "AzureResourceMetric",
                "timeGrain": "PT1M",
            }
        },
    )
    print(response)


# x-ms-original-file: 2025-05-01-preview/SignalDefinitions_CreateOrUpdate.json
if __name__ == "__main__":
    main()
