# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from devtools_testutils import recorded_by_proxy
from testpreparer import AttestationClientTestBase, AttestationPreparer


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestAttestationAttestationOperations(AttestationClientTestBase):
    @AttestationPreparer()
    @recorded_by_proxy
    def test_attestation_attest_open_enclave(self, attestation_endpoint):
        client = self.create_client(endpoint=attestation_endpoint)
        response = client.attestation.attest_open_enclave(
            body={
                "draftPolicyForAttestation": "str",
                "initTimeData": {"data": bytes("bytes", encoding="utf-8"), "dataType": "str"},
                "nonce": "str",
                "report": bytes("bytes", encoding="utf-8"),
                "runtimeData": {"data": bytes("bytes", encoding="utf-8"), "dataType": "str"},
            },
        )

        # please add some check logic here by yourself
        # ...

    @AttestationPreparer()
    @recorded_by_proxy
    def test_attestation_attest_sgx_enclave(self, attestation_endpoint):
        client = self.create_client(endpoint=attestation_endpoint)
        response = client.attestation.attest_sgx_enclave(
            body={
                "draftPolicyForAttestation": "str",
                "initTimeData": {"data": bytes("bytes", encoding="utf-8"), "dataType": "str"},
                "nonce": "str",
                "quote": bytes("bytes", encoding="utf-8"),
                "runtimeData": {"data": bytes("bytes", encoding="utf-8"), "dataType": "str"},
            },
        )

        # please add some check logic here by yourself
        # ...

    @AttestationPreparer()
    @recorded_by_proxy
    def test_attestation_attest_azure_guest(self, attestation_endpoint):
        client = self.create_client(endpoint=attestation_endpoint)
        response = client.attestation.attest_azure_guest(
            body={"attestationInfo": "str"},
        )

        # please add some check logic here by yourself
        # ...

    @AttestationPreparer()
    @recorded_by_proxy
    def test_attestation_attest_tpm(self, attestation_endpoint):
        client = self.create_client(endpoint=attestation_endpoint)
        response = client.attestation.attest_tpm(
            body={"data": bytes("bytes", encoding="utf-8")},
        )

        # please add some check logic here by yourself
        # ...

    @AttestationPreparer()
    @recorded_by_proxy
    def test_attestation_attest_sev_snp_vm(self, attestation_endpoint):
        client = self.create_client(endpoint=attestation_endpoint)
        response = client.attestation.attest_sev_snp_vm(
            body={
                "draftPolicyForAttestation": "str",
                "initTimeData": {"data": bytes("bytes", encoding="utf-8"), "dataType": "str"},
                "nonce": "str",
                "report": "str",
                "runtimeData": {"data": bytes("bytes", encoding="utf-8"), "dataType": "str"},
            },
        )

        # please add some check logic here by yourself
        # ...

    @AttestationPreparer()
    @recorded_by_proxy
    def test_attestation_attest_tdx_vm(self, attestation_endpoint):
        client = self.create_client(endpoint=attestation_endpoint)
        response = client.attestation.attest_tdx_vm(
            body={
                "initTimeData": {"data": bytes("bytes", encoding="utf-8"), "dataType": "str"},
                "nonce": "str",
                "quote": bytes("bytes", encoding="utf-8"),
                "runtimeData": {"data": bytes("bytes", encoding="utf-8"), "dataType": "str"},
            },
        )

        # please add some check logic here by yourself
        # ...
