/********************************************************************\
 * assistant-stock-transaction.h -- stock assistant for GnuCash     *
 * Copyright (C) 2022 Christopher Lam                               *
 *                                                                  *
 * This program is free software; you can redistribute it and/or    *
 * modify it under the terms of the GNU General Public License as   *
 * published by the Free Software Foundation; either version 2 of   *
 * the License, or (at your option) any later version.              *
 *                                                                  *
 * This program is distributed in the hope that it will be useful,  *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of   *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the    *
 * GNU General Public License for more details.                     *
 *                                                                  *
 * You should have received a copy of the GNU General Public License*
 * along with this program; if not, contact:                        *
 *                                                                  *
 * Free Software Foundation           Voice:  +1-617-542-5942       *
 * 51 Franklin Street, Fifth Floor    Fax:    +1-617-542-2652       *
 * Boston, MA  02110-1301,  USA       gnu@gnu.org                   *
\********************************************************************/

#ifndef GNC_ASSISTANT_STOCK_TRANSACTION_H
#define GNC_ASSISTANT_STOCK_TRANSACTION_H

#include "Account.h"

#ifdef __cplusplus
extern "C" {
#endif

/********************************************************************\
 * gnc_stock_transaction_assistant                                  *
 *   opens up a assistant to record a stock transaction             *
 *                                                                  *
 * Args:   parent  - the parent of this window                      *
 *         account - the initial account to use                     *
 * Return: nothing                                                  *
\********************************************************************/
void gnc_stock_transaction_assistant (GtkWidget *parent, Account * account);

#ifdef __cplusplus
}
#endif

#endif
