#!/usr/bin/env python3
# -*- coding: utf-8 -*-

# Fenrir TTY screen reader
# By Chrys, Storm Dragon, and contributors.

from fenrirscreenreader.core.i18n import _
from fenrirscreenreader.utils import mark_utils


class command:
    def __init__(self):
        pass

    def initialize(self, environment):
        self.env = environment

    def shutdown(self):
        pass

    def get_description(self):
        return _("reads from the cursor to the bottom of the screen")

    def run(self):
        # Prefer review cursor over text cursor
        cursor_pos = self.env["runtime"][
            "CursorManager"
        ].get_review_or_text_cursor()

        text_after_cursor = mark_utils.get_text_after_mark(
            cursor_pos, self.env["screen"]["new_content_text"]
        )

        if text_after_cursor.isspace():
            self.env["runtime"]["OutputManager"].present_text(
                _("blank"), sound_icon="EmptyLine", interrupt=True
            )
        else:
            self.env["runtime"]["OutputManager"].present_text(
                text_after_cursor, interrupt=True
            )

    def set_callback(self, callback):
        pass
